//AIM:Compute width of trace,phase velocity and wavelength of microstripline.
//Software version Scilab 5.5.2
//OS Windows 7

clc;
clear;
Zo=50;//Considered characteristic impedence Zo=50ohms
printf("Considered characteristic impedence=%g ohms\n\n",Zo)
//We know that,for characteristic impedence of 50 ohms,the value of w/h is 1.9
mu0=4*%pi*(10^(-7));
epsilon0=8.85*(10^(-12));
Zf=sqrt(mu0/epsilon0);//in ohms
printf('Value of Zf=%g ohms\n\n',Zf)
h=40;//in mil
f=2*10^9;//in Hz
//Er=epsilonr
Er=4.6;
//taking A=2*pi*(Zo/Zf)*(sqrt(Er+1/2))+((Er-1)/(Er+1))*(0.23+0.11/Er)
A=2*%pi*(Zo/Zf)*(sqrt((Er+1)/2))+((Er-1)/(Er+1))*(0.23+0.11/Er);
printf("Value of A=%g \n\n",A)
a=(8*exp(A))/(exp(2*A)-2);//a means the calculation of w/h
//Eeff=effective dielectric constant.
if a>1 then
Eeff=((Er+1)/2)+((Er-1)/2)*((1+12*(a^-1))^-0.5);
printf("Effective permittivity=%g\n\n",Eeff)
Zo1=Zf/(sqrt(Eeff)*(1.393+a+(2/3)*log(a+1.444)));
else
Eeff=((Er+1)/2)+((Er-1)/2)*(((1+12*(a^-1))^-0.5)+(0.04(1-a)^2));
printf("Effective permittivity=%g\n\n",Eeff)
Zo1=(Zf/(2*%pi*sqrt(Eeff)))*log((8*(a^-1))+(0.25*a));
end
Zo1=int(Zo1);
printf("Computed characteristic impedence,Zo1=%g ohms\n\n",Zo1)
if Zo1==Zo then
    printf("The computed value of Zo1 is same as the considered value of Zo\n")
    printf("Hence our design is correct.\n\n")
else
    printf("Design is incorrect.\n\n")
end
w=a*h;
printf("Width of the trace=%g mils\n\n",w)
c=3*10^8;
vp=c/(sqrt(Eeff));
printf("Phase velocity=%g m/s\n\n",vp)
lambda=vp/f;
printf("Wavelength=%g m",lambda)
